#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef struct {
    long long x, y;
    int index;
} Move;

long long distanceSquared(long long x, long long y) {
    return x * x + y * y;
}

int main() {
    int n;
    scanf("%d", &n);
    
    Move moves,[object Object],;
    for (int i = 0; i < n; i++) {
        scanf("%lld %lld", &moves[i].x, &moves[i].y);
        moves[i].index = i + 1;
    }
    
    long long bestDist = 0;
    int bestMask = 0;
    
    // ?? ???? n, ???????? ??? ???????????
    if (n <= 20) {
        for (int mask = 0; mask < (1 << n); mask++) {
            long long x = 0, y = 0;
            for (int i = 0; i < n; i++) {
                if (mask & (1 << i)) {
                    x += moves[i].x;
                    y += moves[i].y;
                }
            }
            long long dist = distanceSquared(x, y);
            if (dist > bestDist) {
                bestDist = dist;
                bestMask = mask;
            }
        }
    } else {
        // ?? ?????? n, ??????? ?????? (greedy) ???????
        // ?????? 4 ?????? ?????? ? ?????? ???????????
        
        // ?????????? 1: ???? ??? ????????? x ? ????????? y
        long long x1 = 0, y1 = 0;
        int mask1 = 0;
        for (int i = 0; i < n; i++) {
            if (moves[i].x > 0 || moves[i].y > 0) {
                x1 += moves[i].x;
                y1 += moves[i].y;
                mask1 |= (1 << (i % 30)); // ?????????? ?? ?????? n
            }
        }
        
        // ?????????? 2: ???? ???
        long long x2 = 0, y2 = 0;
        int mask2 = 0;
        for (int i = 0; i < n; i++) {
            x2 += moves[i].x;
            y2 += moves[i].y;
            mask2 |= (1 << (i % 30));
        }
        
        // ?? n > 30, ????????? ????????? ???????
        // ?????? ????? ????????? ??????? ?????? ?????
        int selected,[object Object],;
        int count = 0;
        long long bestX = 0, bestY = 0;
        
        // ???? ??? ????????
        for (int i = 0; i < n; i++) {
            bestX += moves[i].x;
            bestY += moves[i].y;
            selected[count++] = i + 1;
        }
        bestDist = distanceSquared(bestX, bestY);
        
        // ??????? ?? ??????? ???????? ???? ??????? ?????????
        for (int i = 0; i < n; i++) {
            long long newX = bestX - moves[i].x;
            long long newY = bestY - moves[i].y;
            if (distanceSquared(newX, newY) > bestDist) {
                bestX = newX;
                bestY = newY;
                bestDist = distanceSquared(bestX, bestY);
                // ?????? ???? ??????
                for (int j = 0; j < count; j++) {
                    if (selected[j] == i + 1) {
                        selected[j] = selected[--count];
                        break;
                    }
                }
            }
        }
        
        printf("%d\n", count);
        for (int i = 0; i < count; i++) {
            printf("%d%c", selected[i], i == count - 1 ? '\n' : ' ');
        }
        return 0;
    }
    
    // ?????? ???????? ?? ???? n
    int count = 0;
    int result,[object Object],;
    for (int i = 0; i < n; i++) {
        if (bestMask & (1 << i)) {
            result[count++] = i + 1;
        }
    }
    
    printf("%d\n", count);
    if (count > 0) {
        for (int i = 0; i < count; i++) {
            printf("%d%c", result[i], i == count - 1 ? '\n' : ' ');
        }
    } else {
        printf("\n");
    }
    
    return 0;
}